/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.item.ModItems;

public class ManaGunClipRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<ManaGunClipRecipe> SERIALIZER = new SimpleRecipeSerializer(ManaGunClipRecipe::new);

    public ManaGunClipRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundGun = false;
        boolean foundClip = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ItemManaGun && !ItemManaGun.hasClip(stack)) {
                foundGun = true;
                continue;
            }
            if (stack.m_150930_(ModItems.clip)) {
                foundClip = true;
                continue;
            }
            return false;
        }
        return foundGun && foundClip;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack gun = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemManaGun)) continue;
            gun = stack;
        }
        if (gun.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack lens = ItemManaGun.getLens(gun);
        ItemStack gunCopy = gun.m_41777_();
        ItemManaGun.setLens(gunCopy, ItemStack.f_41583_);
        ItemManaGun.setClip(gunCopy, true);
        ItemManaGun.setLensAtPos(gunCopy, lens, 0);
        return gunCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

